func do_create_genielib(string libname; arglist options) {
# $Header: /project/fpd/cvsroot/fw/genie/src/ge/genielib/do_create_genielib.M,v 1.1.1.1 1993/06/03 16:16:28 jas Exp $
	list flist
	string file
	abstract function f
	int ecnt
	int optimize inc notext secure
	string optflags ccflags
	string modname
	untyped o p
	list srcfiles

	notext = inc = optimize = secure = 0
	optflags = LFHP
	srcfiles = ()
	ccflags = ""
	foreach o @options {
		switch(typestring @o) {
		list {
			if(!@o  || (typestring @o[0]) != string) {
				println "### Bad option" @o
				quit 1
			}
			switch @o[0] {
			srcfiles (srcfiles = @o[1])
			optflags (optflags = @o[1])
			ccflags (ccflags = @o[1])
			module (modname = @o[1])
			() { println "### Bad option" @o; quit 1 }
			}
		}
		string {
			switch @o {
			optimize (optimize = 1)
			nooptimize (optimize = 0)
			isge (inc = 1)
			notext (notext = 1)
			secure (secure = 1)
			() { println "### Bad option" @o; quit 1 }
			}
		}
		() {
			println "### Bad option" @o
			quit 1
		} }
	}
	if(isnull @srcfiles) {
		setpattern "\\.[g]$"
		set srcfiles (dirlistmatch ".")	/* look for all .g files */
		setpattern "\\.[m]$"
		foreach file (dirlistmatch ".") { /* get the .m files */
			prepend srcfiles @file
		}
	}

	ecnt = (g_parseerrcount)
	if @modname {
		with @modname (flist = (ge_funcdeflist '{
			foreach file @srcfiles {
				switch (strtail @file (revscan @file ".")) {
				".g" { println ccing @file; cc "-R" @ccflags @file }
				".m" { println pfing @file; pf @file }
				()   { println "### unknown suffix" @file; quit 1 }
				}
			}
		}))
	} else {
		flist = (ge_funcdeflist '{
			foreach file @srcfiles {
				switch (strtail @file (revscan @file ".")) {
				".g" { println ccing @file; cc "-R" @ccflags @file }
				".m" { println pfing @file; pf @file }
				()   { println "### unknown suffix" @file; quit 1 }
				}
			}
		})
	}
	if @inc (prepend flist (nametoabsfunc do_create_genielib))
	println done parsing
	ecnt = (g_parseerrcount) - @ecnt
	if @ecnt {
		println "###" @ecnt "parsing errors"
		quit 1
	}
	if @optimize {
		println Optimizing functions
		foreach f @flist {
			if(@f._name == do_create_genielib) (continue)
			# println optimizing @f
			ge_optfunc @f @optflags
		}
	}
	if @notext {
		println "Removing text from functions"
		foreach f @flist {
			f._text = ()
		}
	}
	if @secure {
		println "Turning off access to function lists"
		foreach f @flist {
			f._secure = 1
		}
	}
	if @inc {
		f = (nametoabsfunc templicenseid)
		f._secure = 1
	}
	println sorting names
	for(p = &flist[0]; @p; ++ p) {
		f = @@p
		@p = (bld @f._name @f)
	}
	sortlist flist gt 0
	for(p = &flist[0]; @p; ++ p) {
		@p = @@p[1]
	}
	println "flist =" @flist
	println doing archive
	archive @flist @libname
#	quit 0
#       Syeds addition : donot quit PLeaseeeeeeee
        return
Interrupt:
	println Interrupted
#Error:
	println "Error generating genielib"
	println "Errorinfo:" (errorinfo)
	quit 1
}


func altera_compile_custom_code(args text) {

 string curdir
 string tmpdir fname
 string techname
 list ll
      techname = @Techdef.name
      curdir =  (cat @Techdef.tspec.@techname.techdir  "/bin/custom")
      tmpdir = "/tmp/mkcustom"
      fname   = "custom.ma"
      if (isdirectory @tmpdir) {
       sh rm -rf @tmpdir 
      }
      sys_mkdir @tmpdir 
      sh cp (cat @curdir "/code/*.m") (cat @tmpdir "/.") 
      sys_chdir @tmpdir
      append ll "module"
      append ll  @TargetModule
      if (!(@text) ) {
           do_create_genielib @fname @ll 
      } else {
           do_create_genielib @fname @ll notext
      }
      sh mv @fname (cat @curdir "/.")      
      sys_chdir @curdir
      sh rm -rf  @tmpdir
      println "Compiled succcessfully\n"
}
